{********************************************
; File: SANE.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT SANE;
INTERFACE
USES TYPES;
CONST


{ Decimal Representation Constants }
SIGDIGLEN = $001C;
DecStrLen = $00FF;

{ IEEE defualt environment constant }
IEEEDEFAULTENV = $0000;

{ Decimal formatting styles }
FLOATDECIMAL = $0000;
FIXEDDECIMAL = $0001;

{ Exceptions }
INVALID = $0001;
UNDERFLOW = $0002;
OVERFLOW = $0004;
DIVBYZERO = $0008;
INEXACT = $0010;

TYPE

{ Ordering relations }
relop = (GREATERTHAN,LESSTHAN,EQUALTO,UNORDERED);

{ Inquiry classes }
numclass = (SNAN,QNAN,INFINITE,ZERONUM,NORMALNUM,DENORMALNUM);

{ Environmental control }

{ Rounding directions }
rounddir = (TONEAREST,UPWARD,DOWNWARD,TOWARDZERO);

{ Rounding precisions }
roundpre = (EXTPRECISION,DBLPRECISION,FLOATPRECISION);
exception = Integer ;
environment = Integer ;
decimal = RECORD
    sgn : Integer; { 0 for positive, 1 for negative  }
    exp : Integer;
    sig : STRING[SigDigLen];
END;
decform = RECORD
    style : Integer; { FLOATDECIMAL or FIXEDDECIMAL  }
    digits : Integer;
END;
DecStr = STRING[DecStrLen];
CStrPtr = ^CHAR;

haltvector = VoidProcPtr;

{ Conversions between numeric binary types }
FUNCTION  Num2Integer ( x:Extended) : Integer ;
{   }

FUNCTION  Num2Longint ( x:Extended) : Longint ;
{   }

FUNCTION  Num2Real ( x:Extended) : Real ;
{   }

FUNCTION  Num2Double ( x:Extended) : Double ;
{   }

FUNCTION  Num2Extended ( x:Extended) : Extended ;
{   }

FUNCTION  Num2Comp ( x:Extended) : Comp ;
{   }


{ Conversions between binary and decimal }
PROCEDURE num2dec ( f:DecForm; x:extended;VAR d:Decimal)  ; C;
{ d <-- x according to format f }

FUNCTION  dec2num (VAR d:Decimal) : Extended ; C;
{ Dec2Num <-- d as Extended }

PROCEDURE Num2Str ( f:DecForm; x:Extended;VAR s:DecStr)  ;
{ s <-- x according to format f }

FUNCTION  Str2Num ( s:DecStr) : Extended ;
{ Str2Num <-- s }


{ Conversions between decimal formats }
PROCEDURE str2dec ( s:DecStr;VAR index:Integer;VAR d:Decimal;VAR validPrefix:Integer)  ;
{ Input: Index is starting index into s. }
{ Output: Index is 1 + (index of last character of longest numeric substring). }
{ d <-- Decimal rep of longest numeric substring; }
{ validPrefix <-- s, beginning at Index, contains valid numeric string }

PROCEDURE CStr2Dec ( s:CStrPtr;VAR index:Integer;VAR d:Decimal;VAR validPrefix:Integer)  ;
{ For character buffers or C strings instead of Pascal strings. }
{ The first arg is the address of a character buffer. }
{ validPrefix <-- scanning ended with a null byte }

PROCEDURE dec2str ( f:DecForm; d:Decimal;VAR s:DecStr)  ;
{ s <-- d according to format f }


{ Arithmetic, auxiliary and elementary functions }
FUNCTION  remainder ( x:Extended; y:Extended;VAR quo:Integer) : Extended ; C;
{ Remainder <-- x rem y; }
{ quo <-- 7 low-order bits of integer quotient x/y }
{ where -127 < quo < 127 }

FUNCTION  rint ( x:Extended) : Extended ;
{ round to integral value }

FUNCTION  scalb ( n:Integer; x:Extended) : Extended ; C;
{ scale binary; scalb <-- x * 2^n }

FUNCTION  logb ( x:Extended) : Extended ; C;
{ binary log: binary exponent of normalized x }

FUNCTION  copysign ( x:Extended; y:Extended) : Extended ;
{ CopySign <-- y with sign of x }

FUNCTION  NextReal ( x:Real; y:Real) : Real ;
{ next Real rep after (Real) x in direction of (Real) y }

FUNCTION  nextdouble ( x:Double; y:Double) : Double ; C;
{ next Double rep after (Double) x in direction of (Double) y }

FUNCTION  nextextended ( x:Extended; y:Extended) : Extended ; C;
{ next extended representation after x in direction of y }

FUNCTION  log2 ( x:Extended) : Extended ; C;
{ base-2 logarithm }

FUNCTION  Ln1 ( x:Extended) : Extended ;
{ ln(1 + x) }

FUNCTION  exp2 ( x:Extended) : Extended ; C;
{ base-2 exponential }

FUNCTION  exp1 ( x:Extended) : Extended ; C;
{ exp(x) - 1 }

FUNCTION  XpwrY ( x:Extended; y:Extended) : Extended ;
{ general exponential: x ^ i }

FUNCTION  XpwrI ( x:Extended; i:Integer) : Extended ;
{ integer exponential: x ^ i }

FUNCTION  compound ( r:Extended; n:Extended) : Extended ; C;
{ compound: (1 + r) ^ n }

FUNCTION  annuity ( r:Extended; n:Extended) : Extended ; C;
{ Annuity <-- (1 - (1+r)^(-n)) / r }

FUNCTION  tan ( x:Extended) : Extended ; C;
{ tangent }

FUNCTION  randomx (VAR x:Extended) : Extended ; C;
{ returns next random number; updates x; }
{ x must be integral, 1 <= x <= 2^31 - 2 }


{ Inquiry Routines }
FUNCTION  ClassReal ( x:Real) : numclass ;
{ class of (Real) x }

FUNCTION  classdouble ( x:Double) : numclass ; C;
{ class of (Double) x }

FUNCTION  classcomp ( x:Comp) : numclass ; C;
{ class of (Comp) x }

FUNCTION  classextended ( x:Extended) : numclass ; C;
{ class of x }

FUNCTION  signnum ( x:Extended) : Longint ; C;
{ 0 if sign bit clear, 1 if sign bit set }


{ Environment access routines }
PROCEDURE setexception ( e:exception; b:Boolean)  ;
{ clears e flags if b is 0, sets e flags otherwise; may cause halt }

FUNCTION  testexception ( e:exception) : Boolean ;
{ return true if any e flag is set, return false otherwise }

PROCEDURE sethalt ( e:exception; b:Boolean)  ;
{ set e halt enables if b is true, clear e halt enables otherwise }

FUNCTION  testhalt ( e:exception) : Boolean ; C;
{ return true if any e halt is enabled, return false otherwise }

PROCEDURE setround ( r:rounddir)  ;
{ set rounding direction to r }

FUNCTION  getround  : rounddir ;
{ return rounding direction }

PROCEDURE setprecision ( p:roundpre)  ; C;
{ sets rnd'n precision to p }

FUNCTION  getprecision  : roundpre ; C;


PROCEDURE setenvironment ( e:environment)  ; C;
{ sets SANE environment to e }

PROCEDURE getenvironment (VAR e:environment)  ; C;
{ e <-- SANE environment }

PROCEDURE procentry (VAR e:environment)  ;
{ e <-- environment;  environment <-- IEEE default env }

PROCEDURE procexit ( e:environment)  ;
{ temp <-- current exceptions; }
{ SANE environment <-- e; }
{ signals exceptions in temp }

FUNCTION  gethaltvector  : haltvector ; C;
{ return SANE halt vector }

PROCEDURE sethaltvector ( v:haltvector)  ; C;
{ halt vector <-- v }


{ Comparison routine }
FUNCTION  relation ( x:Extended; y:Extended) : relop ; C;
{ return Relation such that "x Relation y" is true }


{ NaNs and Special Constants }
FUNCTION  nan(i: INTEGER): EXTENDED; C;
{ returns NaN with code i }

PROCEDURE SANEBootInit   ;
PROCEDURE SANEStartUp ( dPageAddr:Integer)  ;
PROCEDURE SANEShutDown   ;
FUNCTION  SANEVersion  : Integer ;
PROCEDURE SANEReset   ;
FUNCTION  SANEStatus  : Integer ;
PROCEDURE SANEFP816   ;
PROCEDURE SANEDecStr816   ;
PROCEDURE SANEElems816   ;
PROCEDURE EnvTrap ( e:environment; i:Integer)  ;


PROCEDURE VAREnvTrap (VAR e:environment; i:Integer)  ;


IMPLEMENTATION
END.
